﻿namespace Code6587EN.Ch01.ApplyComposedLook
{
    using Microsoft.SharePoint;
    using System;

    /// <summary>
    /// Console Application to apply a Composed Look
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the SharePoint Site Collection containing the SharePoint Site in a Using statement
            using (var site = new SPSite("http://sharepoint/site")) 
            {
                // Open the SharePoint Site in a Using statement
                using (var web = site.OpenWeb())
                {
                    // Apply the Composed Look elements and update the SharePoint Site
                    web.ApplyTheme("/_catalogs/theme/15/Palette015.spcolor", "/_catalogs/theme/15/fontscheme001.spfont", "/images/background.png", false);
                    web.Update();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
